<?php

namespace App\Providers;

use App\Models\Category;
use Illuminate\Support\ServiceProvider;
use Illuminate\Contracts\Auth\Guard;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(Guard $auth)
    {

        view()->composer('layout.navbar', function ($view) {
            $categories = Category::whereHas('dishes', function ($query) {
                $query->groupBy('Category')
                    ->havingRaw('COUNT(*) > 3');
            })->take(8)->get();

            $view->with('categories', $categories);
        });
    }
}