<?php

use App\Http\Controllers\Auth\LoginRegisterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\ContactUsController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\ModifierController;
use App\Http\Controllers\DishController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\WishlistController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware(['set.guard'])->group(function () {
    Route::post('/login', [LoginRegisterController::class, 'login'])->name('login');
});

Route::post('/register', [LoginRegisterController::class, 'register'])->name('register');

Route::get('/address', [AddressController::class, 'index'])->name('index');

// Public routes (accessible to all users)
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('shop', [ShopController::class, 'index'])->name('shop.index');
Route::get('detail', [ShopController::class, 'detail'])->name('shop.detail');
Route::get('wishlist', [WishlistController::class, 'index'])->name('wishlist');

Route::post('/cart', [CartController::class, 'store'])->name('cart.store');
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::get('/cart/truncate', [CartController::class, 'destroy'])->name('cart.destroy');
Route::post('/cart/removeDish', [CartController::class, 'removeDish'])->name('cart.remov');

Route::post('/cart/update', [CartController::class, 'update'])->name('cart.update');

Route::get('/checkout', [CheckoutController::class, 'index']);
Route::post('/checkout', [CheckoutController::class, 'storeMobile']);

Route::get('/order', [OrderController::class, 'index']);

Route::get('/modifier', [ModifierController::class, 'index']);
Route::post('/modifier', [CartController::class, 'addModifier']);

Route::get('/category', [HomeController::class, 'category'])->name('category.index');

Route::get('/dish/random', [DishController::class, 'indexRandom'])->name('dish.random.index');
Route::get('/dish/{dish_id}', [DishController::class, 'show'])->name('dish.show');
Route::get('/dish', [DishController::class, 'index'])->name('dish.index');

// Logout route (accessible only to authenticated users)
Route::middleware(['auth'])->group(function () {
    // Route::get('/logout', [LoginRegisterController::class, 'logout'])->name('logout');
    Route::post('/logout', [LoginRegisterController::class, 'logout'])->name('logout');
});