<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Dish;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $categories = Category::get();
        $dishes = Dish::get();
        return view('home.index', compact('categories', 'dishes'));
    }

    public function category()
    {
        $categories = Category::get();
        $category_array = [];

        foreach ($categories as $category) {
            $cat = new \stdClass();

            $cat->id = $category->Cat_ID;
            $cat->image = asset('assets/img/categories/' . $category->CategoryName . '.png');
            $cat->title = $category->CategoryName;

            $category_array[] = $cat;
        }
        return response()->json($category_array);
    }
}