<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RestaurantPOS_OrderedProductBillHD extends Model
{
    use HasFactory;
    
    public $timestamps  = false;
    
    protected $table = 'RestaurantPOS_OrderedProductBillHD';
    
    public function getDateFormat()
    {
        return 'Y-d-m H:i:s.v';
    }
    
    public function dish()
    {
        return $this->belongsTo(Dish::class, 'dish_id', 'DishID');
    }
    
    public function dish_name()
    {
        return $this->belongsTo(Dish::class, 'Dish', 'DishName');
    }
}
