@extends('layout.master')

@section('content')
    <div class="product-details pt-100 pb-90">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="product-details-img">
                        @php
                            $image = str_replace('\Menu Items Image\\', '', $dish->Photo);
                        @endphp
                        <img class="zoompro" src="{{ asset('Menu-Items-Image/' . $image) }}"
                            data-zoom-image="{{ asset('Menu-Items-Image/' . $image) }}" alt="zoom" />
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="product-details-content">
                        <h4>{{ $dish->DishName }}</h4>
                        <span>£ {{ $dish->DIRate }}</span>
                        <div class="pro-details-cart-wrap">
                            <div class="shop-list-cart-wishlist">
                                <a title="Add To Cart" href="#" class="add-to-cart" data-dish-id="{{ $dish->DishID }}"
                                    data-dish-name="{{ $dish->DishName }}" data-dish-price="{{ $dish->DIRate }}">
                                    <i class="ion-android-cart"></i>
                                </a>
                            </div>
                            <div class="product-quantity">
                                <div class="cart-plus-minus">
                                    <input class="cart-plus-minus-box" type="text" name="qtybutton" value="1">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="product-area pb-95">
        <div class="container">
            <div class="product-top-bar section-border mb-25">
                <div class="section-title-wrap">
                    <h3 class="section-title section-bg-white">Related Products</h3>
                </div>
            </div>
            <div class="related-product-active owl-carousel product-nav">
                @forelse($related_dishes as $related_dish)
                    <div class="product-wrapper">
                        <div class="product-img">
                            @php
                                $image = str_replace('\Menu Items Image\\', '', $related_dish->Photo);
                                $queryParams = ['dish_id' => $related_dish->DishID];
                                $url = route('shop.detail') . '?' . http_build_query($queryParams);
                            @endphp
                            <a href="{{ $url }}">
                                <img src="{{ asset('Menu-Items-Image/' . $image) }}" alt="">
                            </a>
                            <div class="product-action">
                                <div class="pro-action-left">
                                    <a title="Add Tto Cart" href="#"><i class="ion-android-cart"></i> Add To Cart</a>
                                </div>
                                <div class="pro-action-right">
                                    <a title="Quick View" data-bs-toggle="modal" data-bs-target="#exampleModal"
                                        href="#"><i class="ion-android-open"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="product-content">
                            <h4>
                                <a href="{{ route('shop.detail') }}">{{ $related_dish->DishName }}</a>
                            </h4>
                            <div class="product-price-wrapper">
                                <span>£ {{ $related_dish->DIRate }}</span>
                            </div>
                        </div>
                    </div>
                @empty
                @endforelse
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {

            $('#exampleModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var data = button.data(
                    'dish'); // Get the dish data and image path from the button's data attribute

                // Update modal content with dish data
                $('#dishName').text(data.dish.DishName);
                $('#dishPrice').text('$' + data.dish.DIRate);

                // Update modal image source
                $('#dishImage').attr('src', data.image);
            });

            $(".add-to-cart").click(function(event) {
                event.preventDefault();

                var dishId = $(this).data("dish-id");
                var dishName = $(this).data("dish-name");
                var dishPrice = $(this).data("dish-price");
                var quantity = 1; // You can adjust this as needed

                $.ajax({
                    url: "{{ route('cart.store') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        dish_id: dishId,
                        dish_name: dishName,
                        quantity: quantity,
                        price: dishPrice,
                    },
                    success: function(response) {
                        // Check if the response contains a success message
                        if (response.message) {
                            window.location.reload();
                        } else {
                            // Handle other cases as needed
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error, e.g., display an error message
                        console.error(error);
                    },
                });
            });
        });
    </script>
@endsection
