<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Dish;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::check() ? Auth::user() : null;
        $already_in_cookie = Cookie::get('delivery_type');

        $delivery_type = 1;

        if ($user != null) {
            $delivery_type = $user->delivery_type;
            if ($delivery_type == null) {
                $user->delivery_type = 1;
                $user->save();
            }
        } else if ($user == null && $already_in_cookie != null) {
            $delivery_type = Cookie::get('delivery_type');
        } else {
            Cookie::queue('delivery_type', $delivery_type, 60 * 24 * 30);
        }

        $categories = Category::get();
        $dishes = Dish::get();
        return view('home.index', compact('categories', 'dishes', 'delivery_type'));
    }

    public function category()
    {
        $categories = Category::get();
        $category_array = [];

        foreach ($categories as $category) {
            $cat = new \stdClass();

            $cat->id = $category->Cat_ID;
            $cat->image = asset('assets/img/categories/' . $category->CategoryName . '.png');
            $cat->title = $category->CategoryName;

            $category_array[] = $cat;
        }
        return response()->json($category_array);
    }
}