<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    
    public $timestamps  = true;
    
    public function getDateFormat() {
        return 'Y-d-m H:i:s';
    }

    protected $table = 'RestaurantPOS_BillingInfoHD';

    protected $fillable = [
        'Id',
        'BillNo',
        'BillDate',
        'Operator',
        'SubTotal',
        'HDDiscountPer',
        'HDDiscountAmt',
        'HomeDeliveryCharges',
        'GrandTotal',
        'CustomerName',
        'Address',
        'ContactNo',
        'Employee_ID',
        'PaymentMode',
        'HD_Status',
        'GiftCardAmount',
    ];
    
    public function order_details()
    {
        return $this->hasMany(RestaurantPOS_OrderedProductBillHD::class, 'BillID', 'Id');
    }
}
