<?php

namespace App\Providers;

use App\Models\Category;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\ServiceProvider;
use Illuminate\Contracts\Auth\Guard;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(Guard $auth)
    {

        view()->composer('layout.master', function ($view) {
            $categories = Category::whereHas('dishes', function ($query) {
                $query->groupBy('Category')
                    ->havingRaw('COUNT(*) > 3');
            })->take(8)->get();

            $user = Auth::check() ? Auth::user() : null;
            $already_in_cookie = Cookie::get('delivery_type');

            $delivery_type = 1;

            if ($user != null) {
                $delivery_type = $user->delivery_type;
                if ($delivery_type == null) {
                    $user->delivery_type = 1;
                    $user->save();
                }
            } else if ($user == null && $already_in_cookie != null) {
                $delivery_type = Cookie::get('delivery_type');
            } else {
                Cookie::queue('delivery_type', $delivery_type, 60 * 24 * 30);
            }

            $view->with('categories', $categories)->with('delivery_type', $delivery_type);
        });
    }
}