@extends('layout.master')

@section('content')
    <div class="checkout-area pb-80 pt-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="checkout-wrapper">
                        <div class="panel-body">
                            <form method="post" action="{{ route('checkout.store') }}">
                                @csrf
                                <div class="billing-information-wrapper">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6">
                                            <div class="billing-info">
                                                <label>Name</label>
                                                <input required type="text" name="name">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="billing-info">
                                                <label>Email Address</label>
                                                <input required type="email" name="email">
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12">
                                            <div class="billing-info">
                                                <label>Address</label>
                                                <input required type="text" name="address">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="billing-info">
                                                <label>Zip/Postal Code</label>
                                                <input required type="number" name="postal_code">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="billing-select">
                                                <label>City</label>
                                                <select required name="city">
                                                    <option value="Bath">Bath</option>
                                                    <option value="Birmingham">Birmingham</option>
                                                    <option value="Bradford">Bradford</option>
                                                    <option value="Brighton & Hove">Brighton & Hove</option>
                                                    <option value="Bristol">Bristol</option>
                                                    <option value="Cambridge">Cambridge</option>
                                                    <option value="Canterbury">Canterbury</option>
                                                    <option value="Carlisle">Carlisle</option>
                                                    <option value="Chelmsford">Chelmsford</option>
                                                    <option value="Chester">Chester</option>
                                                    <option value="Chichester">Chichester</option>
                                                    <option value="Colchester">Colchester</option>
                                                    <option value="Coventry">Coventry</option>
                                                    <option value="Derby">Derby</option>
                                                    <option value="Doncaster">Doncaster</option>
                                                    <option value="Durham">Durham</option>
                                                    <option value="Ely">Ely</option>
                                                    <option value="Exeter">Exeter</option>
                                                    <option value="Gloucester">Gloucester</option>
                                                    <option value="Hereford">Hereford</option>
                                                    <option value="Kingston-upon-Hull">Kingston-upon-Hull</option>
                                                    <option value="Lancaster">Lancaster</option>
                                                    <option value="Leeds">Leeds</option>
                                                    <option value="Leicester">Leicester</option>
                                                    <option value="Lichfield">Lichfield</option>
                                                    <option value="Lincoln">Lincoln</option>
                                                    <option value="Liverpool">Liverpool</option>
                                                    <option value="London">London</option>
                                                    <option value="Manchester">Manchester</option>
                                                    <option value="Milton Keynes">Milton Keynes</option>
                                                    <option value="Newcastle-upon-Tyne">Newcastle-upon-Tyne</option>
                                                    <option value="Norwich">Norwich</option>
                                                    <option value="Nottingham">Nottingham</option>
                                                    <option value="Oxford">Oxford</option>
                                                    <option value="Peterborough">Peterborough</option>
                                                    <option value="Plymouth">Plymouth</option>
                                                    <option value="Portsmouth">Portsmouth</option>
                                                    <option value="Preston">Preston</option>
                                                    <option value="Ripon">Ripon</option>
                                                    <option value="Salford">Salford</option>
                                                    <option value="Salisbury">Salisbury</option>
                                                    <option value="Sheffield">Sheffield</option>
                                                    <option value="Southampton">Southampton</option>
                                                    <option value="Southend-on-Sea">Southend-on-Sea</option>
                                                    <option value="St Albans">St Albans</option>
                                                    <option value="Stoke on Trent">Stoke on Trent</option>
                                                    <option value="Sunderland">Sunderland</option>
                                                    <option value="Truro">Truro</option>
                                                    <option value="Wakefield">Wakefield</option>
                                                    <option value="Wells">Wells</option>
                                                    <option value="Westminster">Westminster</option>
                                                    <option value="Winchester">Winchester</option>
                                                    <option value="Wolverhampton">Wolverhampton</option>
                                                    <option value="Worcester">Worcester</option>
                                                    <option value="York">York</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="billing-info">
                                                <label>Contact Number</label>
                                                <input required type="tel" name="contact_number">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="billing-back-btn">
                                        <div class="billing-back">
                                            <a href="#"><i class="ion-arrow-up-c"></i> back</a>
                                        </div>
                                        <div class="billing-btn">
                                            <button type="submit">Place Order</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
