@extends('layout.master')

@section('content')
    <div class="product-details pt-100 pb-90">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="product-details-img">
                        @php
                            $image = str_replace('\Menu Items Image\\', '', $dish->Photo);
                        @endphp
                        <img class="zoompro" src="{{ asset('Menu-Items-Image/' . $image) }}"
                            data-zoom-image="{{ asset('Menu-Items-Image/' . $image) }}" alt="zoom" />
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="product-details-content">
                        <h4>{{ $dish->DishName }}</h4>
                        <span id="totalPrice">£ {{ $delivery_type == 1 ? $dish->HDRate : $dish->TARate }}</span>
                        <div class="pro-details-cart-wrap">
                            <div class="shop-list-cart-wishlist">
                                @if ($delivery_type == 1)
                                    <a title="Add To Cart" href="#" class="add-to-cart"
                                        data-dish-id="{{ $dish->DishID }}" data-dish-name="{{ $dish->DishName }}"
                                        data-dish-price="{{ $dish->HDRate }}">
                                        <i class="ion-android-cart"></i>
                                    </a>
                                @else
                                    <a title="Add To Cart" href="#" class="add-to-cart"
                                        data-dish-id="{{ $dish->DishID }}" data-dish-name="{{ $dish->DishName }}"
                                        data-dish-price="{{ $dish->TARate }}">
                                        <i class="ion-android-cart"></i>
                                    </a>
                                @endif
                            </div>
                            <div class="product-quantity">
                                <div class="cart-plus-minus">
                                    <input class="cart-plus-minus-box" type="number" name="qtybutton" value="1">
                                </div>
                            </div>
                            <div style="padding-top:10px">
                                <select multiple class="js-example-basic-single" name="modifiers" id="modifiersSelect">
                                    @foreach ($dish->modifiers as $modifier)
                                        <option value={{ $modifier->MIM_ID }}>{{ $modifier->ModifierName }} (£
                                            {{ $modifier->Rate }})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="product-area pb-95">
        <div class="container">
            <div class="product-top-bar section-border mb-25">
                <div class="section-title-wrap">
                    <h3 class="section-title section-bg-white">Related Products</h3>
                </div>
            </div>
            <div class="related-product-active owl-carousel product-nav">
                @forelse($related_dishes as $related_dish)
                    <div class="product-wrapper">
                        <div class="product-img">
                            @php
                                $image = str_replace('\Menu Items Image\\', '', $related_dish->Photo);
                                $queryParams = ['dish_id' => $related_dish->DishID];
                                $url = route('shop.detail') . '?' . http_build_query($queryParams);
                            @endphp
                            <a href="{{ $url }}">
                                <img src="{{ asset('Menu-Items-Image/' . $image) }}" alt="">
                            </a>
                            <div class="product-action">
                                <div class="pro-action-left">
                                    <a title="Add To Cart" href="#"><i class="ion-android-cart"></i> Add To Cart</a>
                                </div>
                            </div>
                        </div>
                        <div class="product-content">
                            <h4>
                                <a href="{{ route('shop.detail') }}">{{ $related_dish->DishName }}</a>
                            </h4>
                            <div class="product-price-wrapper">
                                <span>£ {{ $delivery_type == 1 ? $related_dish->HDRate : $related_dish->TARate }}</span>
                            </div>
                        </div>
                    </div>
                @empty
                @endforelse
            </div>
        </div>
    </div>
    @php
        $modifierRates = $dish->modifiers->pluck('Rate', 'MIM_ID')->toArray();
    @endphp
@endsection
@section('header')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

            var modifiersSelect = $('#modifiersSelect');
            var modifierRates = {!! json_encode($modifierRates) !!};
            modifiersSelect.select2({
                placeholder: 'Select modifiers'
            });

            modifiersSelect.on('change', function() {
                updateTotalPrice();
            });

            function updateTotalPrice() {

                var delivery_type = {!! $delivery_type !!};

                var selectedModifiers = modifiersSelect.val();
                var quantity = parseInt($('input[name="qtybutton"]').val());
                if (delivery_type == 1) {
                    var basePrice = {{ $dish->HDRate }}; // Base price of the dish
                } else {
                    var basePrice = {{ $dish->TARate }}; // Base price of the dish
                }

                var totalRate = basePrice * quantity; // Calculate the total price

                if (selectedModifiers) {
                    selectedModifiers.forEach(function(modifierId) {
                        var rate = modifierRates[modifierId]; // Access the rate from the JavaScript object
                        totalRate += parseFloat(rate) *
                            quantity; // Update total rate based on quantity and modifiers
                    });
                }

                // Update the displayed total price
                $('#totalPrice').text('£ ' + totalRate.toFixed(2));
            }

            $('input[name="qtybutton"]').on('input', function() {
                updateTotalPrice();
            });


            $('#exampleModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Button that triggered the modal
                var data = button.data(
                    'dish'); // Get the dish data and image path from the button's data attribute

                // Update modal content with dish data
                $('#dishName').text(data.dish.DishName);

                var delivery_type = {!! $delivery_type !!};
                if (delivery_type == 1) {
                    $('#dishPrice').text('$' + data.dish.HDRate);
                } else {
                    $('#dishPrice').text('$' + data.dish.TARate);
                }

                // Update modal image source
                $('#dishImage').attr('src', data.image);
            });

            $(".add-to-cart").click(function(event) {
                event.preventDefault();

                var dishId = $(this).data("dish-id");
                var dishName = $(this).data("dish-name");
                var dishPrice = $(this).data("dish-price");
                var quantity = parseInt($(this).closest('.product-details-content').find(
                    '.cart-plus-minus-box').val());
                var selectedModifiers = $('#modifiersSelect').val(); // Get selected modifiers

                $.ajax({
                    url: "{{ route('cart.store') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        dish_id: dishId,
                        dish_name: dishName,
                        quantity: quantity,
                        price: dishPrice,
                        modifiers: selectedModifiers
                    },
                    success: function(response) {
                        // Check if the response contains a success message
                        if (response.message) {
                            window.location.reload();
                        } else {
                            // Handle other cases as needed
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error, e.g., display an error message
                        console.error(error);
                    },
                });
            });
        });
    </script>
@endsection
