<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;

    public function getDateFormat()
    {
        return 'Y-d-m H:i:s.v';
    }

    public $timestamps = true;

    protected $fillable = [
        'user_id',
        'dish_id',
        'dish_name',
        'quantity',
        'price',
        'session_id'
    ];

    public function dish()
    {
        return $this->belongsTo(Dish::class, 'dish_id', 'DishID');
    }

    public function modifiers()
    {
        return $this->hasMany(CartModifier::class);
    }
}