<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartModifier extends Model
{
    use HasFactory;

    protected $table = 'cart_modifiers';

    protected $fillable = ['cart_id', 'MIM_ID'];

    public $timestamps = true;

    public function getDateFormat()
    {
        return 'Y-d-m H:i:s';
    }

    public function modifier_name()
    {
        return $this->belongsTo(Modifier::class, 'MIM_ID', 'MIM_ID');
    }
}
