@extends('layout.master')

@section('content')
    <!-- shopping-cart-area start -->
    <div class="cart-main-area pt-95 pb-100">
        <div class="container">
            <h3 class="page-title">Your Orders</h3>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="table-content table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Product Name</th>
                                    <th>Until Price</th>
                                    <th>Qty</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sum = 0;
                                @endphp
                                @forelse($orders as $order)
                                    <tr data-item-id="{{ $order->id }}">
                                        <td class="product-thumbnail">
                                            @php($image = str_replace('\Menu Items Image\\', '', $order->dish_name->Photo))
                                            <a href="#"><img src="{{ asset('Menu-Items-Image/' . $image) }}"
                                                    alt="" width="86px"></a>
                                        </td>
                                        <td class="product-name"><a href="#">{{ $order->dish_name->DishName }}</a>
                                        </td>
                                        <td class="product-price-cart"><span class="amount">£
                                                {{ $order->TotalAmount }}</span>
                                        </td>
                                        <td class="product-quantity">
                                            <span class="amount">{{ $order->Quantity }}</span>
                                        </td>
                                        <td class="product-subtotal">£ {{ $order->TotalAmount * $order->Quantity }}</td>

                                    </tr>
                                    <?php $sum = $sum + $order->price * $order->quantity; ?>
                                @empty
                                    <tr colspan="6">
                                        <td>
                                            No orders
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Function to update the quantity of a cart item
            function updateCartItem(id, quantity) {
                $.ajax({
                    type: 'POST',
                    url: '{{ route('cart.update') }}', // Replace with the actual route name
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                        quantity: quantity
                    },
                    success: function(response) {
                        window.location.reload();
                    },
                    error: function(response) {
                        console.log('Error:', response);
                    }
                });
            }

            // Increment button click event
            $(document).on('click', '.inc', function() {
                var row = $(this).closest('tr');
                var id = row.data('item-id'); // Retrieve 'id' from 'data-item-id'
                var quantityInput = row.find('.cart-plus-minus-box');
                var currentQuantity = parseInt(quantityInput.val());
                var newQuantity = currentQuantity;
                quantityInput.val(newQuantity);

                // Update the cart item with the new quantity
                updateCartItem(id, newQuantity);
            });

            // Decrement button click event
            $(document).on('click', '.dec', function() {
                var row = $(this).closest('tr');
                var id = row.data('item-id'); // Retrieve 'id' from 'data-item-id'
                var quantityInput = row.find('.cart-plus-minus-box');
                var currentQuantity = parseInt(quantityInput.val());

                if (currentQuantity + 1 > 1) {
                    var newQuantity = currentQuantity;
                    quantityInput.val(newQuantity);

                    // Update the cart item with the new quantity
                    updateCartItem(id, newQuantity);
                }
            });
        });

        function removeItem(id) {
            $.ajax({
                type: 'POST',
                url: '{{ route('cart.remove') }}', // Replace with the actual route name
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function(response) {
                    window.location.reload();
                },
                error: function(response) {
                    console.log('Error:', response);
                }
            });
        }
    </script>
@endsection
